//////////////////////////////////////////////////////////////////////////////
// file    : CurveEditor.java
// content : pen tool implementation (step 0)
//////////////////////////////////////////////////////////////////////////////


/* imports *****************************************************************/

import java.util.Vector;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

import java.awt.event.*;
import javax.swing.event.*;

import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;


/* curve editor *************************************************************/

class CurveEditor extends JPanel {
	int W = 640;
	int H = 480;
	
	class PointHandle extends Point {
		static final int R = 2;
		Rectangle handle = new Rectangle(new Dimension(2*R, 2*R));
		
		public PointHandle(Point p) {
			super(p);
			handle.setLocation(this);
			handle.translate(-R, -R);
		}
		
		public void draw(Graphics2D g2) {
			g2.draw(handle);		
		}
	}
	
	Vector<PointHandle> points = new Vector<PointHandle>();
	PenTool pen_tool = new PenTool();
	
	public CurveEditor() {
		setPreferredSize(new Dimension(W, H));
		addMouseListener(pen_tool);
	}


/* drawing ******************************************************************/

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		
		for(PointHandle point: points) {
			point.draw(g2);
		}
	}


/* interaction **************************************************************/

	enum State { IDLE, POSITION }

	class PenTool extends MouseInputAdapter {
		protected State state = State.IDLE;
		protected Point mouse;
		
		public void mousePressed(MouseEvent e) {
			if(e.getButton() != MouseEvent.BUTTON1) { return; }
			switch(state) {
			case IDLE:
				mouse = e.getPoint();
				state = State.POSITION;
				break;
			default:
				break;
			}
		}
		
		public void mouseReleased(MouseEvent e) {
			if(e.getButton() != MouseEvent.BUTTON1) { return; }
			switch(state) {
			case POSITION:
				System.out.println("TODO: Créer un point");
				state = State.IDLE;
				break;
			default:
				break;
			}
		}
	}


/* main *********************************************************************/

	static public void main(final String argv[]) {
		System.setProperty("apple.laf.useScreenMenuBar", "true");
		
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				final JFrame frame = new JFrame("curve-editing");
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				
				final CurveEditor editor = new CurveEditor();
				frame.add(editor);
				frame.pack();
				
				JMenuBar menu_bar = new JMenuBar();
				JMenu menu_edition = new JMenu("Édition");
				menu_edition.add(new AbstractAction("Remise à zéro") {
					public void actionPerformed(ActionEvent e) {
						System.out.println("TODO: RAZ");
					}
				});
				menu_bar.add(menu_edition);
				frame.setJMenuBar(menu_bar);
				
				frame.setVisible(true);
			}
		});
	}

}
